package ru.yandex.canvas.model.video.files;

import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;

import ru.yandex.canvas.model.video.VideoFiles;

public class PackShot {

    private String id;
    private String name;
    private Long stillageId;
    private String largePreviewUrl;
    private String thumbnailUrl;
    private String previewUrl;
    private Boolean archive;
    private String stillageUrl;
    private List<ImageFormat> formats;
    private Date date;
    private Long clientId;

    public static class ImageFormat {
        private Long width;
        private String url;
        private String path;
        private String size;
        private Long height;

        public ImageFormat(VideoFiles.VideoFormat format) {
            this.width = Long.valueOf(format.getWidth());
            this.height = Long.valueOf(format.getHeight());
            this.size = format.getSize();
            this.url = format.getUrl();
            this.path = format.getPath();
        }

        public Long getWidth() {
            return width;
        }

        public String getUrl() {
            return url;
        }

        public String getPath() {
            return path;
        }

        public String getSize() {
            return size;
        }

        public Long getHeight() {
            return height;
        }

        @Override
        public String toString() {
            return "ImageFormat{" +
                    "width=" + width +
                    ", url='" + url + '\'' +
                    ", path='" + path + '\'' +
                    ", size='" + size + '\'' +
                    ", height=" + height +
                    '}';
        }
    }

    public String getId() {
        return id;
    }

    public PackShot setId(String id) {
        this.id = id;
        return this;
    }

    public PackShot(VideoFiles files) {
        this.archive = files.getArchive();
        this.id = files.getId();
        this.largePreviewUrl = files.getLargePreviewUrl();
        this.name = files.getName();
        this.previewUrl = files.getPreviewUrl();
        this.stillageId = files.getStillageId();
        this.thumbnailUrl = files.getThumbnailUrl();
        this.stillageUrl = files.getStillageFileInfo().getUrl();
        this.date = files.getDate();
        this.clientId = files.getClientId();

        if (files.getFormats() != null) {
            this.formats = files.getFormats().stream().map(ImageFormat::new).collect(Collectors.toList());
        }
    }

    public String getStillageUrl() {
        return stillageUrl;
    }

    public void setStillageUrl(String stillageUrl) {
        this.stillageUrl = stillageUrl;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getStillageId() {
        return stillageId;
    }

    public void setStillageId(Long stillageId) {
        this.stillageId = stillageId;
    }

    public String getLargePreviewUrl() {
        return largePreviewUrl;
    }

    public void setLargePreviewUrl(String largePreviewUrl) {
        this.largePreviewUrl = largePreviewUrl;
    }

    public String getThumbnailUrl() {
        return thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public Boolean getArchive() {
        return archive;
    }

    public void setArchive(Boolean archive) {
        this.archive = archive;
    }

    public List<ImageFormat> getFormats() {
        return formats;
    }

    public void setFormats(List<ImageFormat> formats) {
        this.formats = formats;
    }

    public Long getClientId() {
        return clientId;
    }

    public Date getDate() {
        return date;
    }

    @Override
    public String toString() {
        return "PackShot{" +
                "id='" + id + '\'' +
                ", name='" + name + '\'' +
                ", stillageId=" + stillageId +
                ", largePreviewUrl='" + largePreviewUrl + '\'' +
                ", thumbnailUrl='" + thumbnailUrl + '\'' +
                ", previewUrl='" + previewUrl + '\'' +
                ", archive=" + archive +
                ", stillageUrl='" + stillageUrl + '\'' +
                ", formats=" + formats +
                ", date=" + date +
                ", clientId=" + clientId +
                '}';
    }
}
