package ru.yandex.canvas.model.video.files;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;

import ru.yandex.canvas.model.video.VideoFiles;
import ru.yandex.canvas.service.video.files.MergedFileRecord;

public class StreamFormat {
    private String delivery;
    private Integer width;
    private String url;
    @JsonProperty("type")
    private String mimeType;
    private Long bitrate;
    private String id;
    private Integer height;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String codec;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Integer framerate;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Long fileSize;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Boolean hasAudio;
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private Double vmafAvg;

    public StreamFormat(MergedFileRecord.FormatDescription description) {
        delivery = description.getDelivery();
        width = description.getWidth() == null ? null : Integer.parseInt(description.getWidth());
        url = description.getUrl();
        mimeType = description.getMimeType();
        bitrate = description.getBitrate();
        id = description.getId();
        height = description.getHeight() == null ? null : Integer.parseInt(description.getHeight());
    }

    public StreamFormat(VideoFiles.VideoFormat description) {
        delivery = description.getDelivery();
        width = description.getWidth() == null ? null : Integer.parseInt(description.getWidth());
        url = description.getUrl();
        mimeType = description.getMimeType();
        bitrate = description.getBitrate();
        id = description.getId();
        height = description.getHeight() == null ? null : Integer.parseInt(description.getHeight());
        codec = description.getCodec();
        framerate = description.getFramerate();
        fileSize = description.getFileSize();
        hasAudio = description.getHasAudio();
        vmafAvg = description.getVmafAvg();
    }

    public StreamFormat(String delivery, Integer width, String url, String mimeType, Integer height, String id,
                        Long fileSize, Boolean hasAudio) {
        this.delivery = delivery;
        this.width = width;
        this.url = url;
        this.mimeType = mimeType;
        this.height = height;
        this.id = id;
        this.fileSize = fileSize;
        this.hasAudio = hasAudio;
    }

    public String getDelivery() {
        return delivery;
    }

    public Integer getWidth() {
        return width;
    }

    public String getUrl() {
        return url;
    }

    public String getMimeType() {
        return mimeType;
    }

    public Long getBitrate() {
        return bitrate;
    }

    public String getId() {
        return id;
    }

    public Integer getHeight() {
        return height;
    }

    public String getCodec() {
        return codec;
    }

    public Integer getFramerate() {
        return framerate;
    }

    public Long getFileSize() {
        return fileSize;
    }

    public Boolean getHasAudio() {
        return hasAudio;
    }

    public Double getVmafAvg() {
        return vmafAvg;
    }

    @Override
    public String toString() {
        return "StreamFormat{" +
                "delivery='" + delivery + '\'' +
                ", width='" + width + '\'' +
                ", url='" + url + '\'' +
                ", mimeType='" + mimeType + '\'' +
                ", bitrate=" + bitrate +
                ", id='" + id + '\'' +
                ", height='" + height + '\'' +
                ", codec='" + codec + '\'' +
                ", framerate='" + framerate + '\'' +
                ", fileSize='" + fileSize + '\'' +
                ", hasAudio='" + hasAudio + '\'' +
                ", vmafAvg='" + vmafAvg + '\'' +
                '}';
    }
}
