package ru.yandex.canvas.model.video.files;

import ru.yandex.canvas.model.video.VideoFiles;
import ru.yandex.canvas.service.video.files.MergedFileRecord;

public class Thumbnail {
    private String url;
    private Long width;
    private Long height;
    private ThumbnailPreview preview;

    public Thumbnail(MergedFileRecord.ThumbnailDescription description) {
        url = description.getUrl();
        width = description.getWidth();
        height = description.getHeight();
        preview = new ThumbnailPreview(description.getPreview());
    }

    public Thumbnail(VideoFiles.VideoThumbnail thumbnail) {
        url = thumbnail.getUrl();
        width = thumbnail.getWidth();
        height = thumbnail.getHeight();
        preview = new ThumbnailPreview(thumbnail.getPreview());
    }

    public String getUrl() {
        return url;
    }

    public Long getWidth() {
        return width;
    }

    public Long getHeight() {
        return height;
    }

    public ThumbnailPreview getPreview() {
        return preview;
    }

    public static class ThumbnailPreview {
        private String url;
        private Long width;
        private Long height;

        public ThumbnailPreview(MergedFileRecord.ThumbnailDescription.ThumbnailPreviewDescription description) {
            url = description.getUrl();
            width = description.getWidth();
            height = description.getHeight();
        }

        public ThumbnailPreview(VideoFiles.VideoThumbnail.ThumbnailPreview preview) {
            url = preview.getUrl();
            width = preview.getWidth();
            height = preview.getHeight();
        }

        public String getUrl() {
            return url;
        }

        public Long getWidth() {
            return width;
        }

        public Long getHeight() {
            return height;
        }
    }
}
