package ru.yandex.canvas.model.video.files;

import java.math.BigInteger;
import java.util.Date;
import java.util.Objects;

import javax.annotation.Nullable;

import ru.yandex.canvas.service.video.files.MergedFileRecord;

public class VideoSource implements MediaDataSource {
    private String categoryId;
    private Thumbnail thumbnail;
    private String overlayColor;
    private String stillageId;
    private BigInteger videoMetaId;//идентификатор видео в VH CMS
    private String playerId;
    private String name;
    private String id;
    private String stillageUrl;
    private String firstFrameUrl;
    private String ratio;
    private Integer ratioPercent;
    private String stockId;
    private Date date;
    private Long clientId;
    private String mimeType;
    private Integer width;
    private Integer height;
    private String signaturesUrl;


    public VideoSource(String categoryId, Thumbnail thumbnail, String overlayColor, String stillageId, String name,
                       String id, String stillageUrl, String ratio, Integer ratioPercent, String stockId, Date date,
                       Long clientId, String mimeType, Integer width, Integer height, BigInteger videoMetaId,
                       String firstFrameUrl, String playerId, String signaturesUrl) {
        this.categoryId = categoryId;
        this.thumbnail = thumbnail;
        this.overlayColor = overlayColor;
        this.stillageId = stillageId;
        this.name = name;
        this.id = id;
        this.stillageUrl = stillageUrl;
        this.firstFrameUrl = firstFrameUrl;
        this.ratio = ratio;
        this.ratioPercent = ratioPercent;
        this.stockId = stockId;
        this.date = date;
        this.clientId = clientId;
        this.mimeType = mimeType;
        this.width = width;
        this.height = height;
        this.videoMetaId = videoMetaId;
        this.playerId = playerId;
        this.signaturesUrl = signaturesUrl;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        VideoSource that = (VideoSource) o;
        return Objects.equals(id, that.id);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id);
    }

    public String getStockId() {
        return stockId;
    }

    public String getRatio() {
        return ratio;
    }

    public Integer getRatioPercent() {
        return ratioPercent;
    }

    public static String getIdFromDescription(MergedFileRecord rootRecord) {
        return rootRecord.getVideo().getSourceId();
    }

    public String getCategoryId() {
        return categoryId;
    }

    @Nullable
    public Thumbnail getThumbnail() {
        return thumbnail;
    }

    public String getOverlayColor() {
        return overlayColor;
    }

    public String getStillageId() {
        return stillageId;
    }

    public BigInteger getVideoMetaId() {
        return videoMetaId;
    }
    public String getPlayerId() {
        return playerId;
    }

    public String getName() {
        return name;
    }

    public Date getDate() {
        return date;
    }

    public Long getClientId() {
        return clientId;
    }

    @Override
    public FileType getSourceType() {
        return FileType.VIDEO;
    }

    public String getId() {
        return id;
    }

    public String getStillageUrl() {
        return stillageUrl;
    }

    public String getFirstFrameUrl() {
        return firstFrameUrl;
    }

    public String getSignaturesUrl() {
        return signaturesUrl;
    }

    public String getMimeType() {
        return mimeType;
    }

    public Integer getWidth() {
        return width;
    }

    public Integer getHeight() {
        return height;
    }

    @Override
    public String toString() {
        return "VideoSource{" +
                "categoryId='" + categoryId + '\'' +
                ", thumbnail=" + thumbnail +
                ", overlayColor='" + overlayColor + '\'' +
                ", stillageId='" + stillageId + '\'' +
                ", name='" + name + '\'' +
                ", id='" + id + '\'' +
                ", stillageUrl='" + stillageUrl + '\'' +
                ", ratio='" + ratio + '\'' +
                ", stockId='" + stockId + '\'' +
                ", date=" + date +
                ", clientId=" + clientId +
                '}';
    }

    public static class VideoSourceBuilder {
        private String categoryId;
        private Thumbnail thumbnail;
        private String overlayColor;
        private String stillageId;
        private BigInteger videoMetaId;
        private String playerId;
        private String name;
        private String id;
        private String stillageUrl;
        private String firstFrameUrl;
        private String ratio;
        private Integer ratioPercent;
        private String stockId;
        private Date date;
        private Long clientId;
        private String mimeType;
        private Integer width;
        private Integer height;
        private String signaturesUrl;

        public VideoSourceBuilder setCategoryId(String categoryId) {
            this.categoryId = categoryId;
            return this;
        }

        public VideoSourceBuilder setThumbnail(Thumbnail thumbnail) {
            this.thumbnail = thumbnail;
            return this;
        }

        public VideoSourceBuilder setOverlayColor(String overlayColor) {
            this.overlayColor = overlayColor;
            return this;
        }

        public VideoSourceBuilder setStillageId(String stillageId) {
            this.stillageId = stillageId;
            return this;
        }

        public VideoSourceBuilder setVideoMetaId(BigInteger videoMetaId) {
            this.videoMetaId = videoMetaId;
            return this;
        }

        public VideoSourceBuilder setPlayerId(String playerId) {
            this.playerId = playerId;
            return this;
        }

        public VideoSourceBuilder setName(String name) {
            this.name = name;
            return this;
        }

        public VideoSourceBuilder setId(String id) {
            this.id = id;
            return this;
        }

        public VideoSourceBuilder setStillageUrl(String stillageUrl) {
            this.stillageUrl = stillageUrl;
            return this;
        }

        public VideoSourceBuilder setFirstFrameUrl(String firstFrameUrl) {
            this.firstFrameUrl = firstFrameUrl;
            return this;
        }

        public VideoSourceBuilder setRatio(String ratio) {
            this.ratio = ratio;
            return this;
        }

        public VideoSourceBuilder setRatioPercent(Integer ratioPercent) {
            this.ratioPercent = ratioPercent;
            return this;
        }

        public VideoSourceBuilder setStockId(String stockId) {
            this.stockId = stockId;
            return this;
        }

        public VideoSourceBuilder setDate(Date date) {
            this.date = date;
            return this;
        }

        public VideoSourceBuilder setClientId(Long clientId) {
            this.clientId = clientId;
            return this;
        }

        public VideoSourceBuilder setMimeType(String mimeType) {
            this.mimeType = mimeType;
            return this;
        }

        public VideoSourceBuilder setWidth(Integer width) {
            this.width = width;
            return this;
        }

        public VideoSourceBuilder setHeight(Integer height) {
            this.height = height;
            return this;
        }

        public VideoSourceBuilder setSignaturesUrl(String signaturesUrl) {
            this.signaturesUrl = signaturesUrl;
            return this;
        }

        public VideoSource build() {
            return new VideoSource(categoryId, thumbnail, overlayColor, stillageId, name, id, stillageUrl, ratio,
                    ratioPercent, stockId, date, clientId, mimeType, width, height, videoMetaId, firstFrameUrl, playerId,
                    signaturesUrl);
        }
    }
}
