package ru.yandex.canvas.model.video.overlay;

import java.util.Date;
import java.util.List;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

/**
 * overlay-бандл
 * Загружается в виде zip-архива. Архив распаковывается, файлы складываются в stillage.
 */
@Document(collection = "overlay_bundles")
public class OverlayBundle {
    @Id
    private String id;

    @Field("client_id")
    private Long clientId;

    /**
     * Храним все файлы списком -- на будущее, потому как
     * никто не гарантирует, что файлов будет всего два, как сейчас (один vast и один js)
     * Файлы хранятся в исходном виде (без вставленных значений в плейсхолдеры)
     */
    @Field("files")
    private List<OverlayAsset> files;

    @Field("date")
    private Date date;

    @Field("archive")
    private Boolean archive;

    /**
     * VAST, уже с вставленными значениям в плейсхолдеры.
     * Этот код уже может быть использован для показа.
     */
    @Field("vast")
    private String vast;

    @Field("name")
    private String name;

    public String getId() {
        return id;
    }

    public OverlayBundle setId(String id) {
        this.id = id;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public OverlayBundle setClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public List<OverlayAsset> getFiles() {
        return files;
    }

    public OverlayBundle setFiles(List<OverlayAsset> files) {
        this.files = files;
        return this;
    }

    public Date getDate() {
        return date;
    }

    public OverlayBundle setDate(Date date) {
        this.date = date;
        return this;
    }

    public Boolean getArchive() {
        return archive;
    }

    public OverlayBundle setArchive(Boolean archive) {
        this.archive = archive;
        return this;
    }

    public String getVast() {
        return vast;
    }

    public OverlayBundle setVast(String vast) {
        this.vast = vast;
        return this;
    }

    public String getName() {
        return name;
    }

    public OverlayBundle setName(String name) {
        this.name = name;
        return this;
    }

    @Override
    public String toString() {
        return "OverlayBundle{" +
                "id='" + id + '\'' +
                ", clientId=" + clientId +
                ", files=" + files +
                ", date=" + date +
                ", archive=" + archive +
                ", name='" + name + '\'' +
                '}';
    }
}
