package ru.yandex.canvas.model.video.overlay;


import java.util.Date;

import javax.validation.constraints.NotNull;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import ru.yandex.canvas.controllers.video.DateSerializer;

/**
 * Оверлейный креатив.
 */
@Document(collection = "overlay_creatives")
public class OverlayCreative {
    @Id
    private String id;

    @Field("preset_id")
    @JsonProperty("preset_id")
    private Long presetId;

    @Field("name")
    @JsonProperty("name")
    private String name;

    @Field("client_id")
    @JsonProperty("client_id")
    private Long clientId;

    @Field("archive")
    private Boolean archive;

    @Field("date")
    @JsonSerialize(using = DateSerializer.class)
    private Date date;

    @Field("overlay_id")
    @JsonProperty("overlay_id")
    @NotNull
    private String overlayId;

    @Field("vast")
    private String vast;

    @Field("creative_id")
    @JsonProperty("creative_id")
    private Long creativeId;

    public String getId() {
        return id;
    }

    public OverlayCreative setId(String id) {
        this.id = id;
        return this;
    }

    public Long getPresetId() {
        return presetId;
    }

    public OverlayCreative setPresetId(Long presetId) {
        this.presetId = presetId;
        return this;
    }

    public String getName() {
        return name;
    }

    public OverlayCreative setName(String name) {
        this.name = name;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public OverlayCreative setClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Boolean getArchive() {
        return archive;
    }

    public OverlayCreative setArchive(Boolean archive) {
        this.archive = archive;
        return this;
    }

    public Date getDate() {
        return date;
    }

    public OverlayCreative setDate(Date date) {
        this.date = date;
        return this;
    }

    public String getOverlayId() {
        return overlayId;
    }

    public OverlayCreative setOverlayId(String overlayId) {
        this.overlayId = overlayId;
        return this;
    }

    public String getVast() {
        return vast;
    }

    public OverlayCreative setVast(String vast) {
        this.vast = vast;
        return this;
    }

    public Long getCreativeId() {
        return creativeId;
    }

    public OverlayCreative setCreativeId(Long creativeId) {
        this.creativeId = creativeId;
        return this;
    }

    @Override
    public String toString() {
        return "OverlayCreative{" +
                "id='" + id + '\'' +
                ", presetId=" + presetId +
                ", name='" + name + '\'' +
                ", clientId=" + clientId +
                ", archive=" + archive +
                ", date=" + date +
                ", overlayId='" + overlayId + '\'' +
                ", creativeId=" + creativeId +
                '}';
    }
}
