package ru.yandex.canvas.model.video.vc.feed;

import java.util.Date;
import java.util.List;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

@Document(collection = "video_constructor_feed_files")
@CompoundIndexes({
        @CompoundIndex(def = "{'client_id': 1, 'creation_time': 1}"),
        @CompoundIndex(def = "{'client_id': 1, 'creation_time': -1}")
})
public class VideoConstructorFeed {
    @Id
    private String id;

    @Field("name")
    private String name;

    @Field("user_id")
    private Long userId;

    @Field("client_id")
    private Long clientId;

    @Field("creation_time")
    private Date creationTime;

    @Field("archive")
    private Boolean archive;

    @Field("url_raw_data")
    private String urlRawData;

    @Field("url")
    private String url;

    @Field("rows_count")
    private Integer rowsCount;

    @Field("fields")
    private List<VideoConstructorFeedField> fields;

    @Field("original_feed_id")
    private String originalFeedId;

    @Field("crop_params")
    private List<VideoConstructorFeedCropParams> cropParams;

    public String getId() {
        return id;
    }

    public VideoConstructorFeed withId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public VideoConstructorFeed withName(String name) {
        this.name = name;
        return this;
    }

    public Long getUserId() {
        return userId;
    }

    public VideoConstructorFeed withUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public VideoConstructorFeed withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Date getCreationTime() {
        return creationTime;
    }

    public VideoConstructorFeed withCreationTime(Date creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public Boolean getArchive() {
        return archive;
    }

    public VideoConstructorFeed withArchive(Boolean archive) {
        this.archive = archive;
        return this;
    }

    public String getUrlRawData() {
        return urlRawData;
    }

    public VideoConstructorFeed withUrlRawData(String urlRawData) {
        this.urlRawData = urlRawData;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public VideoConstructorFeed withUrl(String url) {
        this.url = url;
        return this;
    }

    public Integer getRowsCount() {
        return rowsCount;
    }

    public VideoConstructorFeed withRowsCount(Integer rowsCount) {
        this.rowsCount = rowsCount;
        return this;
    }

    public List<VideoConstructorFeedField> getFields() {
        return fields;
    }

    public VideoConstructorFeed withFields(List<VideoConstructorFeedField> fields) {
        this.fields = fields;
        return this;
    }

    public String getOriginalFeedId() {
        return originalFeedId;
    }

    public VideoConstructorFeed withOriginalFeedId(String originalFeedId) {
        this.originalFeedId = originalFeedId;
        return this;
    }

    public List<VideoConstructorFeedCropParams> getCropParams() {
        return cropParams;
    }

    public VideoConstructorFeed withCropParams(List<VideoConstructorFeedCropParams> cropParams) {
        this.cropParams = cropParams;
        return this;
    }
}
