package ru.yandex.canvas.model.video.vc.feed;

import java.util.Locale;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;

import ru.yandex.canvas.MongoLowerCaseEnum;

public enum VideoConstructorFeedFieldType implements MongoLowerCaseEnum {
    TEXT,
    IMAGE,
    VIDEO,
    AUDIO;

    @JsonValue
    public String getValue() {
        return name().toLowerCase();
    }

    @JsonCreator
    public static VideoConstructorFeedFieldType fromString(String name) {
        return VideoConstructorFeedFieldType.valueOf(name.toUpperCase(Locale.ROOT));
    }
}
