package ru.yandex.canvas.model.video.vc.files;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.springframework.data.annotation.Id;
import org.springframework.data.mongodb.core.index.CompoundIndex;
import org.springframework.data.mongodb.core.index.CompoundIndexes;
import org.springframework.data.mongodb.core.index.IndexDirection;
import org.springframework.data.mongodb.core.index.Indexed;
import org.springframework.data.mongodb.core.mapping.Document;
import org.springframework.data.mongodb.core.mapping.Field;

import ru.yandex.canvas.model.video.files.FileStatus;

@Document(collection = "video_constructor_files")
@CompoundIndexes({
        @CompoundIndex(def = "{'client_id': 1, 'creation_time': 1}"),
        @CompoundIndex(def = "{'client_id': 1, 'creation_time': -1}"),
        @CompoundIndex(def = "{'client_id': 1, 'date': 1}"),
        @CompoundIndex(def = "{'client_id': 1, 'date': -1}")
})
public class VideoConstructorFile {
    @Id
    private String id;

    @Field("name")
    private String name;

    @Field("user_id")
    private Long userId;

    @Field("client_id")
    private Long clientId;

    @Field("date")
    private Date date;

    @Field("creation_time")
    private Date creationTime;

    @Field("url")
    private String url;

    @Field("audio_url")
    private String audioUrl;

    @Field("duration")
    private Double duration;

    @Field("feed_id")
    private String feedId;

    @Field("feed_archive_url")
    private String feedArchiveUrl;

    @Field("feed_archive_urls")
    private List<String> feedArchiveUrls;

    @Field("feed_result_url")
    private String feedResultUrl;

    @Field("feed_mp4_urls")
    private List<String> feedMp4Urls;

    @Field("feed_audio_field_name")
    private String feedAudioFieldName;

    @Field("width")
    private Long width;

    @Field("height")
    private Long height;

    @Field("fps")
    private Long fps;

    @Field("scale")
    private Long scale;

    @Field("archive")
    private Boolean archive;

    @Field("mp4Url")
    private String mp4Url;

    @Field("mp4_stillage_id")
    private String mp4StillageId;

    @Field("gifUrl")
    private String gifUrl;

    @Field("gif_stillage_id")
    private String gifStillageId;

    @Field("packshotUrl")
    private String packshotUrl;

    @Field("packshot_stillage_id")
    private String packshotStillageId;

    @Field("previewUrl")
    private String previewUrl;

    @Field("preview_stillage_id")
    private String previewStillageId;

    @Field("status")
    @Indexed(direction = IndexDirection.ASCENDING)
    private FileStatus status;

    @Field("params")
    private Map<String, Object> params;

    @Field("group")
    private String group;

    public String getId() {
        return id;
    }

    public VideoConstructorFile withId(String id) {
        this.id = id;
        return this;
    }

    public String getName() {
        return name;
    }

    public VideoConstructorFile withName(String name) {
        this.name = name;
        return this;
    }

    public Long getUserId() {
        return userId;
    }

    public VideoConstructorFile withUserId(Long userId) {
        this.userId = userId;
        return this;
    }

    public Long getClientId() {
        return clientId;
    }

    public VideoConstructorFile withClientId(Long clientId) {
        this.clientId = clientId;
        return this;
    }

    public Date getDate() {
        return date;
    }

    public VideoConstructorFile withDate(Date date) {
        this.date = date;
        return this;
    }

    public Date getCreationTime() {
        return creationTime;
    }

    public VideoConstructorFile withCreationTime(Date creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public VideoConstructorFile withUrl(String url) {
        this.url = url;
        return this;
    }

    public String getAudioUrl() {
        return audioUrl;
    }

    public VideoConstructorFile withAudioUrl(String audioUrl) {
        this.audioUrl = audioUrl;
        return this;
    }

    public Double getDuration() {
        return duration;
    }

    public VideoConstructorFile withDuration(Double duration) {
        this.duration = duration;
        return this;
    }

    public String getFeedId() {
        return feedId;
    }

    public VideoConstructorFile withFeedId(String feedId) {
        this.feedId = feedId;
        return this;
    }

    public String getFeedArchiveUrl() {
        return feedArchiveUrl;
    }

    public VideoConstructorFile withFeedArchiveUrl(String feedArchiveUrl) {
        this.feedArchiveUrl = feedArchiveUrl;
        return this;
    }

    public List<String> getFeedArchiveUrls() {
        return feedArchiveUrls;
    }

    public VideoConstructorFile withFeedArchiveUrls(List<String> feedArchiveUrls) {
        this.feedArchiveUrls = feedArchiveUrls;
        return this;
    }

    public String getFeedResultUrl() {
        return feedResultUrl;
    }

    public VideoConstructorFile withFeedResultUrl(String feedResultUrl) {
        this.feedResultUrl = feedResultUrl;
        return this;
    }

    public List<String> getFeedMp4Urls() {
        return feedMp4Urls;
    }

    public VideoConstructorFile withFeedMp4Urls(List<String> feedMp4Urls) {
        this.feedMp4Urls = feedMp4Urls;
        return this;
    }

    public String getFeedAudioFieldName() {
        return feedAudioFieldName;
    }

    public VideoConstructorFile withFeedAudioFieldName(String feedAudioFieldName) {
        this.feedAudioFieldName = feedAudioFieldName;
        return this;
    }

    public Long getWidth() {
        return width;
    }

    public VideoConstructorFile withWidth(Long width) {
        this.width = width;
        return this;
    }

    public Long getHeight() {
        return height;
    }

    public VideoConstructorFile withHeight(Long height) {
        this.height = height;
        return this;
    }

    public Long getFps() {
        return fps;
    }

    public VideoConstructorFile withFps(Long fps) {
        this.fps = fps;
        return this;
    }

    public Long getScale() {
        return scale;
    }

    public VideoConstructorFile withScale(Long scale) {
        this.scale = scale;
        return this;
    }

    public Boolean getArchive() {
        return archive;
    }

    public VideoConstructorFile withArchive(Boolean archive) {
        this.archive = archive;
        return this;
    }

    public String getMp4Url() {
        return mp4Url;
    }

    public VideoConstructorFile withMp4Url(String mp4Url) {
        this.mp4Url = mp4Url;
        return this;
    }

    public String getMp4StillageId() {
        return mp4StillageId;
    }

    public VideoConstructorFile withMp4StillageId(String mp4StillageId) {
        this.mp4StillageId = mp4StillageId;
        return this;
    }

    public String getGifUrl() {
        return gifUrl;
    }

    public VideoConstructorFile withGifUrl(String gifUrl) {
        this.gifUrl = gifUrl;
        return this;
    }

    public String getGifStillageId() {
        return gifStillageId;
    }

    public VideoConstructorFile withGifStillageId(String gifStillageId) {
        this.gifStillageId = gifStillageId;
        return this;
    }

    public String getPackshotUrl() {
        return packshotUrl;
    }

    public VideoConstructorFile withPackshotUrl(String packshotUrl) {
        this.packshotUrl = packshotUrl;
        return this;
    }

    public String getPackshotStillageId() {
        return packshotStillageId;
    }

    public VideoConstructorFile withPackshotStillageId(String packshotStillageId) {
        this.packshotStillageId = packshotStillageId;
        return this;
    }

    public String getPreviewUrl() {
        return previewUrl;
    }

    public void setPreviewUrl(String previewUrl) {
        this.previewUrl = previewUrl;
    }

    public String getPreviewStillageId() {
        return previewStillageId;
    }

    public void setPreviewStillageId(String previewStillageId) {
        this.previewStillageId = previewStillageId;
    }

    public FileStatus getStatus() {
        return status;
    }

    public VideoConstructorFile withStatus(FileStatus status) {
        this.status = status;
        return this;
    }

    public Map<String, Object> getParams() {
        return params;
    }

    public VideoConstructorFile withParams(Map<String, Object> params) {
        this.params = params;
        return this;
    }

    public String getGroup() {
        return group;
    }

    public VideoConstructorFile withGroup(String group) {
        this.group = group;
        return this;
    }
}
