package ru.yandex.canvas.model.video.vh;

import java.io.IOException;
import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;

@JsonIgnoreProperties(ignoreUnknown = true)
public class TranscoderInfo {
    @JsonProperty("OutputUrl")
    private String outputUrl;
    @JsonProperty("InputUrl")
    private String inputUrl;
    @JsonProperty("InputHeight")
    private Long inputHeight;
    @JsonProperty("InputWidth")
    private Long inputWidth;
    @JsonProperty("FirstFrameUrl")
    private String firstFrameUrl;

    @JsonProperty("SignaturesUrl")
    private String signaturesUrl;
    @JsonProperty("HasAudioStream")
    private Boolean hasAudioStream;
    @JsonProperty("TaskId")
    private String taskId;
    @JsonProperty("FileSize")
    private Long fileSize;
    @JsonProperty("DurationMs")
    private Long durationMs;
    @JsonProperty("GraphMeta")
    private GraphMeta graphMeta;
    @JsonProperty("Streams")
    private List<VhStream> streams;

    public String getOutputUrl() {
        return outputUrl;
    }

    public TranscoderInfo setOutputUrl(String outputUrl) {
        this.outputUrl = outputUrl;
        return this;
    }

    public String getInputUrl() {
        return inputUrl;
    }

    public TranscoderInfo setInputUrl(String inputUrl) {
        this.inputUrl = inputUrl;
        return this;
    }

    public Long getInputHeight() {
        return inputHeight;
    }

    public TranscoderInfo setInputHeight(Long inputHeight) {
        this.inputHeight = inputHeight;
        return this;
    }

    public Long getInputWidth() {
        return inputWidth;
    }

    public TranscoderInfo setInputWidth(Long inputWidth) {
        this.inputWidth = inputWidth;
        return this;
    }

    public String getFirstFrameUrl() {
        return firstFrameUrl;
    }

    public TranscoderInfo setFirstFrameUrl(String firstFrameUrl) {
        this.firstFrameUrl = firstFrameUrl;
        return this;
    }

    public String getSignaturesUrl() {
        return signaturesUrl;
    }
    public Boolean getHasAudioStream() {
        return hasAudioStream;
    }

    public TranscoderInfo setHasAudioStream(Boolean hasAudioStream) {
        this.hasAudioStream = hasAudioStream;
        return this;
    }

    public String getTaskId() {
        return taskId;
    }

    public TranscoderInfo setTaskId(String taskId) {
        this.taskId = taskId;
        return this;
    }

    public Long getFileSize() {
        return fileSize;
    }

    public TranscoderInfo setFileSize(Long fileSize) {
        this.fileSize = fileSize;
        return this;
    }

    public Long getDurationMs() {
        return durationMs;
    }

    public TranscoderInfo setDurationMs(Long durationMs) {
        this.durationMs = durationMs;
        return this;
    }

    public GraphMeta getGraphMeta() {
        return graphMeta;
    }

    public TranscoderInfo setGraphMeta(String graphMetaString) throws IOException {
        //Вручную так как в поле GraphMeta приходит экранированна строка и её нужно дальше дессериализовать
        ObjectMapper objectMapper = new ObjectMapper();
        this.graphMeta = objectMapper.readValue(graphMetaString, GraphMeta.class);
        return this;
    }

    public List<VhStream> getStreams() {
        return streams;
    }

    public TranscoderInfo setStreams(List<VhStream> streams) {
        this.streams = streams;
        return this;
    }

    @Override
    public String toString() {
        return "TranscoderInfo{" +
                "outputUrl='" + outputUrl + '\'' +
                ", inputUrl='" + inputUrl + '\'' +
                ", inputHeight=" + inputHeight +
                ", inputWidth=" + inputWidth +
                ", firstFrameUrl='" + firstFrameUrl + '\'' +
                ", signaturesUrl='" + signaturesUrl + '\'' +
                ", hasAudioStream=" + hasAudioStream +
                ", taskId='" + taskId + '\'' +
                ", fileSize=" + fileSize +
                ", durationMs=" + durationMs +
                ", graphMeta=" + graphMeta +
                ", streams=" + streams +
                '}';
    }
}
