package ru.yandex.canvas.model.video.vh;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(ignoreUnknown = true)
public class VhFormat {
    private Long bitrate;
    private Long height;
    private Long width;
    private String id;
    private String type;
    private String url;
    private String codecs;

    public Long getBitrate() {
        return bitrate;
    }

    public VhFormat setBitrate(Long bitrate) {
        this.bitrate = bitrate;
        return this;
    }

    public Long getHeight() {
        return height;
    }

    public VhFormat setHeight(Long height) {
        this.height = height;
        return this;
    }

    public Long getWidth() {
        return width;
    }

    public VhFormat setWidth(Long width) {
        this.width = width;
        return this;
    }

    public String getId() {
        return id;
    }

    public VhFormat setId(String id) {
        this.id = id;
        return this;
    }

    public String getType() {
        return type;
    }

    public VhFormat setType(String type) {
        this.type = type;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public VhFormat setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getCodecs() {
        return codecs;
    }

    public VhFormat setCodecs(String codecs) {
        this.codecs = codecs;
        return this;
    }

    @Override
    public String toString() {
        return "VhFormat{" +
                "bitrate=" + bitrate +
                ", height=" + height +
                ", width=" + width +
                ", id='" + id + '\'' +
                ", type='" + type + '\'' +
                ", url='" + url + '\'' +
                ", codecs='" + codecs + '\'' +
                '}';
    }
}
