package ru.yandex.canvas.model.video.vh;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

// https://a.yandex-team.ru/arc/trunk/arcadia/extsearch/video/robot/rt_transcoder/proto/task.proto?rev=r8185428#L365-390
@JsonIgnoreProperties(ignoreUnknown = true)
public class VhStream {
    @JsonProperty("Bitrate")
    private Long bitrate;
    @JsonProperty("Height")
    private Long height;
    @JsonProperty("Width")
    private Long width;
    @JsonProperty("FormatStr")
    private String formatName;
    @JsonProperty("Url")
    private String url;
    @JsonProperty("RfcCodecs")
    private String codecs;
    @JsonProperty("ByteSize")
    private Long byteSize;
    @JsonProperty("QualityMetrics")
    private List<VhQualityMetrics> qualityMetrics;
    @JsonProperty("TagsStr")
    private List<String> tagsStr;

    public Long getBitrate() {
        return bitrate;
    }

    public VhStream setBitrate(Long bitrate) {
        this.bitrate = bitrate;
        return this;
    }

    public Long getHeight() {
        return height;
    }

    public VhStream setHeight(Long height) {
        this.height = height;
        return this;
    }

    public Long getWidth() {
        return width;
    }

    public VhStream setWidth(Long width) {
        this.width = width;
        return this;
    }

    public String getFormatName() {
        return formatName;
    }

    public VhStream setFormatName(String formatName) {
        this.formatName = formatName;
        return this;
    }

    public String getUrl() {
        return url;
    }

    public VhStream setUrl(String url) {
        this.url = url;
        return this;
    }

    public String getCodecs() {
        return codecs;
    }

    public VhStream setCodecs(String codecs) {
        this.codecs = codecs;
        return this;
    }

    public Long getByteSize() {
        return byteSize;
    }

    public VhStream setByteSize(Long byteSize) {
        this.byteSize = byteSize;
        return this;
    }

    public List<VhQualityMetrics> getQualityMetrics() {
        return qualityMetrics;
    }

    public VhStream setQualityMetrics(List<VhQualityMetrics> qualityMetrics) {
        this.qualityMetrics = qualityMetrics;
        return this;
    }

    public List<String> getTagsStr() {
        return tagsStr;
    }

    @Override
    public String toString() {
        return "VhStream{" +
                "bitrate=" + bitrate +
                ", height=" + height +
                ", width=" + width +
                ", formatName='" + formatName + '\'' +
                ", url='" + url + '\'' +
                ", codecs='" + codecs + '\'' +
                ", byteSize='" + byteSize + '\'' +
                ", qualityMetrics='" + qualityMetrics + '\'' +
                ", tagsStr='" + tagsStr + '\'' +
                '}';
    }
}
