package ru.yandex.canvas.model.video.vh;

import java.math.BigInteger;
import java.time.LocalDateTime;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(ignoreUnknown = true)
public class VhVideo {
    @JsonProperty("create_time")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = "yyyy-MM-dd'T'HH:mm:ss[.SSSSSS]XXX")
    private LocalDateTime createTime;
    private String service;
    private String thumbnail;
    @JsonProperty("transcoder_info")
    private TranscoderInfo transcoderInfo;
    @JsonProperty("transcoder_status")
    private String transcoderStatus;
    @JsonProperty("video_file_id")
    private BigInteger videoFileId;
    @JsonProperty("player_id")
    private String playerId;

    public LocalDateTime getCreateTime() {
        return createTime;
    }

    public VhVideo setCreateTime(LocalDateTime createTime) {
        this.createTime = createTime;
        return this;
    }

    public String getService() {
        return service;
    }

    public VhVideo setService(String service) {
        this.service = service;
        return this;
    }

    public String getThumbnail() {
        return thumbnail;
    }

    public VhVideo setThumbnail(String thumbnail) {
        this.thumbnail = thumbnail;
        return this;
    }

    public TranscoderInfo getTranscoderInfo() {
        return transcoderInfo;
    }

    public VhVideo setTranscoderInfo(TranscoderInfo transcoderInfo) {
        this.transcoderInfo = transcoderInfo;
        return this;
    }

    public String getTranscoderStatus() {
        return transcoderStatus;
    }

    public boolean isError() {
        return transcoderStatus != null && transcoderStatus.toLowerCase().contains("error");
    }

    public boolean isDone() {
        return transcoderStatus != null && transcoderStatus.toLowerCase().contains("done");
    }

    public VhVideo setTranscoderStatus(String transcoderStatus) {
        this.transcoderStatus = transcoderStatus;
        return this;
    }

    public BigInteger getVideoFileId() {
        return videoFileId;
    }

    public VhVideo setVideoFileId(BigInteger videoFileId) {
        this.videoFileId = videoFileId;
        return this;
    }
    public String getPlayerId() {
        return playerId;
    }

    public VhVideo setPlayerId(String playerId) {
        this.playerId = playerId;
        return this;
    }

    @Override
    public String toString() {
        return "VhVideo{" +
                "createTime='" + createTime + '\'' +
                ", service='" + service + '\'' +
                ", thumbnail='" + thumbnail + '\'' +
                ", transcoderInfo=" + transcoderInfo +
                ", transcoderStatus='" + transcoderStatus + '\'' +
                ", videoFileId=" + videoFileId +
                ", playerId=" + playerId +
                '}';
    }
}
