package ru.yandex.canvas.repository.mongo;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.data.mongodb.core.query.Criteria;

import static com.google.common.base.Preconditions.checkState;

@ParametersAreNonnullByDefault
public abstract class CriteriaBuilderBase<BuilderType, EntityType> {

    protected List<Criteria> andConditions;
    protected List<Criteria> orConditions;

    CriteriaBuilderBase() {
        andConditions = new ArrayList<>();
        orConditions = new ArrayList<>();
    }

    public BuilderType and(Criteria criteria) {
        andConditions.add(criteria);
        return (BuilderType) this;
    }

    public BuilderType or(Criteria criteria) {
        orConditions.add(criteria);
        return (BuilderType) this;
    }

    public abstract EntityType build();

    void checkBuilderState() {
        checkState(andConditions.isEmpty() ^ orConditions.isEmpty());
    }

    Criteria buildCriteriaWithExplicitOperation() {
        Criteria criteria = new Criteria();

        if (!andConditions.isEmpty()) {
            criteria = criteria.andOperator(StreamEx.of(andConditions).toArray(Criteria[]::new));
        }

        if (!orConditions.isEmpty()) {
            criteria = criteria.orOperator(StreamEx.of(orConditions).toArray(Criteria[]::new));
        }

        return criteria;
    }
}
