package ru.yandex.canvas.repository.mongo;

import java.util.Collection;
import java.util.regex.Pattern;

import javax.annotation.ParametersAreNonnullByDefault;

import one.util.streamex.StreamEx;
import org.springframework.data.mongodb.core.query.Criteria;

@ParametersAreNonnullByDefault
public class MongoField {

    private final String fieldPath;

    private MongoField(String fieldPath) {
        this.fieldPath = fieldPath;
    }

    public static MongoField ofFieldPath(String... fieldPath) {
        return new MongoField(StreamEx.of(fieldPath).joining("."));
    }

    public String getFieldPath() {
        return fieldPath;
    }

    public Criteria in(Collection<?> values) {
        return Criteria.where(fieldPath).in(values);
    }

    public Criteria in(Object... values) {
        return Criteria.where(fieldPath).in(values);
    }

    public Criteria is(Object value) {
        return Criteria.where(fieldPath).is(value);
    }

    public Criteria exists(boolean b) {
        return Criteria.where(fieldPath).exists(b);
    }

    public Criteria regex(Pattern pattern) {
        return Criteria.where(fieldPath).regex(pattern);
    }

    public Criteria regex(String regexp, String opts) {
        return Criteria.where(fieldPath).regex(regexp, opts);
    }
}
