package ru.yandex.canvas.repository.mongo;

import java.util.List;

import one.util.streamex.StreamEx;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import static java.util.Collections.singletonList;

public class QueryBuilder extends CriteriaBuilderBase<QueryBuilder, Query> {

    public static QueryBuilder builder() {
        return new QueryBuilder();
    }

    public Query build() {
        checkBuilderState();

        List<Criteria> criterias = canUseImplicitAndOperation() ? andConditions :
                singletonList(buildCriteriaWithExplicitOperation());

        Query query = new Query();
        criterias.forEach(query::addCriteria);
        return query;
    }

    private boolean canUseImplicitAndOperation() {
        return !andConditions.isEmpty() &&
                StreamEx.of(andConditions)
                        .map(Criteria::getKey)
                        .toSet()
                        .size() == andConditions.size();
    }
}
