package ru.yandex.canvas.service;

import java.util.Optional;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthRequestParamsImpl implements AuthRequestParams {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthRequestParams.class);
    private static final String CLIENT_ID = "client_id";

    @Nullable
    private Long userId = null;

    @Nullable
    private final Long clientId;

    public AuthRequestParamsImpl(@NotNull HttpServletRequest httpRequest,SessionParams sessionParams) {
        Long clientId = null;

        if (sessionParams.getClientId() != null) {
            clientId = sessionParams.getClientId();
        }
        else {
            String clientIdRaw = httpRequest.getParameter(CLIENT_ID);
            try {
                if (StringUtils.isNumeric(clientIdRaw)) {
                    clientId = Long.parseLong(clientIdRaw);
                }
            } catch (NumberFormatException ex) {
                LOGGER.warn("Got nonparseable client_id  (" + clientIdRaw +")");
            }
        }

        this.clientId = clientId;
    }

    @Override
    public void setUserId(Long userId) {
        this.userId = userId;
    }

    @NotNull
    public Optional<Long> getUserId() {
        return Optional.ofNullable(userId);
    }

    @NotNull
    public Optional<Long> getClientId() {
        return Optional.ofNullable(clientId);
    }
}

