package ru.yandex.canvas.service;

import org.jetbrains.annotations.NotNull;

import ru.yandex.canvas.exceptions.UnauthorizedException;
import ru.yandex.canvas.model.direct.Privileges;

/**
 * Created by solovyev on 11.07.17.
 */
public interface AuthService {
    Privileges authenticate();

    void requirePermissionDifferentClient(long clientId, @NotNull Privileges.Permission permission);

    boolean checkPermissionDifferentClient(long clientId, @NotNull Privileges.Permission permission);

    void requirePermission(@NotNull Privileges.Permission permission);

    boolean checkPermission(@NotNull Privileges.Permission permission);

    String ping();

    long getUserId() throws UnauthorizedException;
}
