package ru.yandex.canvas.service;

import ru.yandex.canvas.model.CreativeDocument;
import ru.yandex.canvas.model.CreativeDocumentBatch;

import static ru.yandex.canvas.service.PresetsService.GEO_PIN_PRESET_IDS;

public class CreativeBatchDocumentsConsumerFacade implements CreativeBatchDocumentsConsumer {

    private final CreativeBatchDocumentsConsumerImpl creativeBatchDocumentsConsumer;
    private final GeoPinCreativeBatchDocumentsConsumerImpl geoPinCreativeBatchDocumentsConsumer;

    public CreativeBatchDocumentsConsumerFacade(CreativeBatchDocumentsConsumerImpl creativeBatchDocumentsConsumer,
                                                GeoPinCreativeBatchDocumentsConsumerImpl geoPinCreativeBatchDocumentsConsumer) {
        this.creativeBatchDocumentsConsumer = creativeBatchDocumentsConsumer;
        this.geoPinCreativeBatchDocumentsConsumer = geoPinCreativeBatchDocumentsConsumer;
    }

    @Override
    public CreativeDocument enrichCreativeFromBatch(CreativeDocument creativeDocument, CreativeDocumentBatch batch) {
        if (creativeDocument.getPresetId() == null) {
            return creativeBatchDocumentsConsumer.enrichCreativeFromBatch(creativeDocument, batch);
        } else if (GEO_PIN_PRESET_IDS.contains(creativeDocument.getPresetId())) {
            return geoPinCreativeBatchDocumentsConsumer.enrichCreativeFromBatch(creativeDocument, batch);
        } else {
            return creativeBatchDocumentsConsumer.enrichCreativeFromBatch(creativeDocument, batch);
        }
    }
}
