package ru.yandex.canvas.service;

import ru.yandex.canvas.model.CreativeDocument;
import ru.yandex.canvas.model.CreativeDocumentBatch;

public class CreativeBatchDocumentsConsumerImpl implements CreativeBatchDocumentsConsumer {
    private final PreviewUrlBuilder previewUrlBuilder;

    public CreativeBatchDocumentsConsumerImpl(PreviewUrlBuilder previewUrlBuilder) {
        this.previewUrlBuilder = previewUrlBuilder;
    }

    @Override
    public CreativeDocument enrichCreativeFromBatch(CreativeDocument creative, CreativeDocumentBatch batch) {
        creative.setBatchId(batch.getId());
        creative.setName(batch.getName());
        creative.setDate(batch.getDate());
        creative.setPreviewURL(previewUrlBuilder.buildPreviewUrl(batch.getClientId(), creative));
        creative.setClientId(batch.getClientId());
        return creative;
    }
}
