package ru.yandex.canvas.service;

import ru.yandex.canvas.model.CreativeDocument;

import static ru.yandex.canvas.service.PresetsService.GEO_PIN_PRESET_IDS;

public class CreativeDocumentModifierFacade implements CreativeDocumentModifier {
    private final HtmlCreativeDocumentModifierImpl creativeDocumentModifier;
    private final GeoPinCreativeDocumentModifierImpl geoPinCreativeDocumentModifier;

    public CreativeDocumentModifierFacade(HtmlCreativeDocumentModifierImpl creativeDocumentModifier,
                                          GeoPinCreativeDocumentModifierImpl geoPinCreativeDocumentModifier) {
        this.creativeDocumentModifier = creativeDocumentModifier;
        this.geoPinCreativeDocumentModifier = geoPinCreativeDocumentModifier;
    }

    @Override
    public void processCreativeDocument(String batchName, CreativeDocument creativeDocument, long clientId) {
        if (creativeDocument.getPresetId() == null) {
            creativeDocumentModifier.processCreativeDocument(batchName, creativeDocument, clientId);
        } else if (GEO_PIN_PRESET_IDS.contains(creativeDocument.getPresetId())) {
            geoPinCreativeDocumentModifier.processCreativeDocument(batchName, creativeDocument, clientId);
        } else {
            creativeDocumentModifier.processCreativeDocument(batchName, creativeDocument, clientId);
        }
    }
}
