package ru.yandex.canvas.service;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import com.google.common.io.Resources;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.canvas.model.disclaimers.Disclaimer;

/**
 * @author skirsanov
 */
public class DisclaimersService {

    private static final Logger logger = LoggerFactory.getLogger(DisclaimersService.class);

    private static final String DISCLAIMERS_FILE_PATH = "disclaimers.json";
    private static final String DISCLAIMERS_NEW_FORMAT_FILE_PATH = "disclaimers_new_format.json";

    private List<Disclaimer> disclaimers = new ArrayList<>();

    private List<Disclaimer> disclaimersNewFormat = new ArrayList<>();

    public DisclaimersService() {
        final Gson gson = new Gson();
        try {
            disclaimers.addAll(gson.fromJson(Resources.toString(Resources.getResource(DISCLAIMERS_FILE_PATH),
                    StandardCharsets.UTF_8),
                    new TypeToken<Collection<Disclaimer>>() {
                    }.getType()));
        } catch (IOException e) {
            logger.error("can not load disclaimers", e);
            throw new RuntimeException("can not load disclaimers", e);
        }

        try {
            disclaimersNewFormat.addAll(gson.fromJson(Resources.toString(Resources.getResource(DISCLAIMERS_NEW_FORMAT_FILE_PATH),
                            StandardCharsets.UTF_8),
                    new TypeToken<Collection<Disclaimer>>() {
                    }.getType()));
        } catch (IOException e) {
            logger.error("can not load disclaimers_new_format", e);
            throw new RuntimeException("can not load disclaimers_new_format", e);
        }
    }

    public List<Disclaimer> getList() {
        return disclaimers;
    }

    public List<Disclaimer> getListNewFormat() {
        return disclaimersNewFormat;
    }
}
