package ru.yandex.canvas.service;

import java.util.List;
import java.util.ResourceBundle;

import org.apache.poi.common.usermodel.HyperlinkType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Hyperlink;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFSheet;

import ru.yandex.canvas.model.CreativeDocument;
import ru.yandex.canvas.model.CreativeDocumentBatch;

import static java.util.ResourceBundle.getBundle;
import static org.springframework.context.i18n.LocaleContextHolder.getLocale;

/**
 * @author skirsanov
 */
public class ExcelExportService {

    private static String getLocalized(final ResourceBundle bundle, final String key) {
        return bundle.containsKey(key) ? bundle.getString(key) : key;
    }

    public static void fillCreativesWorkbook(final Workbook workbook, final List<CreativeDocumentBatch> batches) {

        final ResourceBundle bundle = getBundle("localized.Excel", getLocale());

        final CreationHelper creationHelper = workbook.getCreationHelper();

        final Sheet sheet = workbook.createSheet("creatives");
        /* SXSSFSheet here created in fact, since we use AbstractXlsxStreamingView. For safety reasons we check
         * this type instead of casting.
         */
        if (sheet instanceof SXSSFSheet) {
            ((SXSSFSheet) sheet).trackAllColumnsForAutoSizing();
        }

        // create header row
        final Row header = sheet.createRow(0);
        header.createCell(0).setCellValue(getLocalized(bundle, "header_name"));  //Название группы
        header.createCell(1).setCellValue(getLocalized(bundle, "header_image"));  // Изображение
        header.createCell(2).setCellValue(getLocalized(bundle, "header_height"));  // Длина
        header.createCell(3).setCellValue(getLocalized(bundle, "header_width"));  // Ширина
        header.createCell(4).setCellValue("creative_id");

        // Create data cells
        int rowCount = 1;
        for (CreativeDocumentBatch batch : batches) {
            for (CreativeDocument creative : batch.getItems()) {
                if (creative.getAvailable()) {
                    Row courseRow = sheet.createRow(rowCount++);
                    courseRow.createCell(0).setCellValue(creative.getName());

                    final Hyperlink link = creationHelper.createHyperlink(HyperlinkType.URL);
                    link.setAddress(creative.getPreviewURL());

                    final Cell cell = courseRow.createCell(1);
                    cell.setCellValue(creative.getPreviewURL());
                    cell.setHyperlink(link);

                    courseRow.createCell(2).setCellValue(creative.getData().getHeight());
                    courseRow.createCell(3).setCellValue(creative.getData().getWidth());
                    courseRow.createCell(4).setCellValue(creative.getId());
                }
            }
        }

        for (int colNum = 0; colNum < header.getLastCellNum(); colNum++) {
            sheet.autoSizeColumn(colNum);
        }
    }
}
