package ru.yandex.canvas.service;

import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonProperty;

public class FeatureResponse {

    @JsonProperty("result")
    private ClientUidFeaturesIntapi result;

    public ClientUidFeaturesIntapi getResult() {
        return result;
    }

    public void setResult(ClientUidFeaturesIntapi result) {
        this.result = result;
    }

    public static class ClientUidFeaturesIntapi {
        @JsonProperty("uids_features")
        private Map<Long, List<String>> uidsFeatures;

        @JsonProperty("client_ids_features")
        private Map<Long, List<String>> clientIdsFeatures;

        public Map<Long, List<String>> getUidsFeatures() {
            return uidsFeatures;
        }

        public ClientUidFeaturesIntapi withUidsFeatures(
                Map<Long, List<String>> uidsFeatures) {
            this.uidsFeatures = uidsFeatures;
            return this;
        }

        public Map<Long, List<String>> getClientIdsFeatures() {
            return clientIdsFeatures;
        }

        public ClientUidFeaturesIntapi withClientIdsFeatures(
                Map<Long, List<String>> clientIdsFeatures) {
            this.clientIdsFeatures = clientIdsFeatures;
            return this;
        }
    }
}
