package ru.yandex.canvas.service;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.canvas.exceptions.ValidationErrorsException;

public abstract class FileValidator {
    private List<String> errorMessages = new ArrayList<>();
    private TankerKeySet keyset;

    public FileValidator(TankerKeySet keyset) {
        this.keyset = keyset;
    }

    public abstract void validate();

    protected boolean addErrorMessage(String msgKey, Object... args) {
        errorMessages.add(keyset.interpolate(msgKey, args));
        return false; // чтобы сразу кидать return из валидации
    }

    protected void addPlainErrorMessages(List<String> plainErrorMessages) {
        errorMessages.addAll(plainErrorMessages);
    }

    protected void throwValidationErrors() {
        if (!errorMessages.isEmpty()) {
            throw new ValidationErrorsException(errorMessages);
        }
    }

    protected void addErrorMessageAndThrowValidationErrors(String msgKey, Object... args) {
        errorMessages.add(keyset.interpolate(msgKey, args));
        throw new ValidationErrorsException(errorMessages);
    }
}
