package ru.yandex.canvas.service;

import java.util.Map;

import ru.yandex.canvas.model.CreativeDocument;
import ru.yandex.canvas.model.CreativeDocumentBatch;
import ru.yandex.canvas.model.MediaSet;
import ru.yandex.canvas.model.elements.Element;

public class GeoPinCreativeBatchDocumentsConsumerImpl extends CreativeBatchDocumentsConsumerImpl {
    public GeoPinCreativeBatchDocumentsConsumerImpl(PreviewUrlBuilder previewUrlBuilder) {
        super(previewUrlBuilder);
    }

    @Override
    public CreativeDocument enrichCreativeFromBatch(CreativeDocument creative, CreativeDocumentBatch batch) {
        revertGeoPinImages(creative);
        return super.enrichCreativeFromBatch(creative, batch);
    }

    private String getBackupOrigMediaSetKey(String mediaSetKey) {
        return mediaSetKey + "_orig";
    }

    /**
     * Восстанавливаем исходные картинки вместо модифицированных. Модификации не должны накладываться друг на друга.
     */
    private void revertGeoPinImages(CreativeDocument creative) {
        Map<String, MediaSet> mediaSets = creative.getData().getMediaSets();
        if (mediaSets == null) {
            return;
        }
        for (Element e : creative.getData().getElements()) {
            String mediaSetKey = e.getMediaSet();
            if (mediaSetKey == null) {
                continue;
            }
            String origMediaSetKey = getBackupOrigMediaSetKey(mediaSetKey);
            MediaSet backup = mediaSets.remove(origMediaSetKey);
            if (backup == null) {
                continue;
            }

            mediaSets.put(mediaSetKey, backup);
        }
    }
}
