package ru.yandex.canvas.service;

import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

public class MongoHelper {
    private MongoHelper() {
    }

    public static Query findByIdQuery(final String id, final long clientId) {
        // Old batches have Double _id, new - ObjectId.
        // See BANNERSTORAGE-4727
        final Object searchId = id.length() < 24 ? Double.valueOf(id).intValue() : id;

        return new Query(Criteria.where("id").is(searchId).andOperator(Criteria.where("clientId").is(clientId)
                .andOperator(Criteria.where("archive").is(false))));
    }
}
