package ru.yandex.canvas.service;

import org.springframework.http.HttpHeaders;

import ru.yandex.direct.tvm.TvmIntegration;
import ru.yandex.direct.tvm.TvmService;

/**
 * Tvm-интеграция настроенная на определенный внешний сервис, под бину на сервис
 */
public class TvmIntegrationService {
    /** Квалификаторы для бинов
     *  {@link org.springframework.beans.factory.annotation.Qualifier}
     */

    public static final String DIRECT_INTAPI = "direct_intapi_tvm_integration";
    public static final String AVATARS_TVM = "avatars_tvm_integration";

    private TvmIntegration tvmIntegration;
    private Integer foreignTvmApplicationId; // Id приложения с которым хотим общаться

    public TvmIntegrationService(TvmIntegration tvmIntegration, Integer foreignTvmApplicationId) {
        this.tvmIntegration = tvmIntegration;
        this.foreignTvmApplicationId = foreignTvmApplicationId;
    }

    public HttpHeaders getHttpHeadersWithTvmTicket() {
        HttpHeaders httpHeaders = new HttpHeaders();

        TvmService dstForeignService = TvmService.fromIdStrict(foreignTvmApplicationId);
        String foreignAppTvmTicket = tvmIntegration.getTicket(dstForeignService);
        if (foreignAppTvmTicket != null) {
            httpHeaders.add(tvmIntegration.serviceTicketHeaderName(), foreignAppTvmTicket);
        }
        return httpHeaders;
    }
}
