package ru.yandex.canvas.service;

import java.util.HashSet;

import org.jetbrains.annotations.NotNull;

import ru.yandex.canvas.exceptions.AuthException;
import ru.yandex.canvas.model.direct.Privileges;

/**
 * Like AuthServiceHttpProxy, but which only gives limited set of permissions if userId was set.
 * <p>
 * Could be useful for more complicated scenarios but if they wouldn't be required this service could
 * be simplified and replaced with in-place checks.
 * <p>
 * Temporary solution™ for ~1 year (starting from 2018/02/14).
 * <p>
 * WARN: Do not use auth features in standard executor's threads, cause it has no request thread local context.
 */
public class UserAuthService {
    private final AuthRequestParams authRequestParams;

    public UserAuthService(@NotNull AuthRequestParams authRequestParams) {
        this.authRequestParams = authRequestParams;
    }

    /**
     * WARN: Do not use auth features in standard executor's threads, cause it has no request thread local context.
     *
     * @return Privileges with a set of Permissions
     */
    private Privileges authenticate() {
        final Long userId = authRequestParams.getUserId().orElse(null);

        HashSet<Privileges.Permission> permissions = new HashSet<>();

        if (userId != null) {
            permissions.add(Privileges.Permission.USER_FILES);
        }

        return new Privileges(permissions);
    }

    /**
     * WARN: Do not use auth features in standard executor's threads, cause it has no request thread local context.
     */
    public void requirePermission(@NotNull Privileges.Permission permission) {
        if (!authenticate().checkPermissionOn(permission)) {
            throw new AuthException(permission.getRestrictedMsg());
        }
    }
}
