package ru.yandex.canvas.service;


import java.util.List;
import java.util.Map;

public class VideoLimits implements VideoLimitsInterface {

    private Double durationMin;
    private Double durationMax;
    private Double durationCaptureStop;
    private Double durationDelta; // +/- .5 secs, see https://st.yandex-team.ru/CANVAS-767
    private Integer videoFrameRateMin;
    private Integer videoFrameRateMax;
    private Integer videoHeightMin;
    private Integer videoHeightMax;
    private Integer videoWidthMin;
    private Integer videoWidthMax;
    private Integer videoSizeMbMax;
    private List<String> allowedVideoHwRatio;
    private List<String> allowedVideoCodecs;
    private Boolean audioRequired;
    private Double audioDurationMin;
    private Double audioDurationMax;
    private List<String> allowedAudioCodecs;
    private Map<String, Object> durationLimitsByRatio;
    private List<String> knownMimeTypes;
    private String videoFileHelpUrl;

    public VideoLimits() {
    }

    @Override
    public Double getDurationMin() {
        return durationMin;
    }

    public void setDurationMin(Double durationMin) {
        this.durationMin = durationMin;
    }

    @Override
    public Double getDurationMax() {
        return durationMax;
    }

    public void setDurationMax(Double durationMax) {
        this.durationMax = durationMax;
    }

    @Override
    public Double getDurationCaptureStop() {
        return durationCaptureStop;
    }

    public void setDurationCaptureStop(Double durationCaptureStop) {
        this.durationCaptureStop = durationCaptureStop;
    }

    @Override
    public Double getDurationDelta() {
        return durationDelta;
    }

    public void setDurationDelta(Double durationDelta) {
        this.durationDelta = durationDelta;
    }

    @Override
    public Integer getVideoFrameRateMin() {
        return videoFrameRateMin;
    }

    public void setVideoFrameRateMin(Integer videoFrameRateMin) {
        this.videoFrameRateMin = videoFrameRateMin;
    }

    @Override
    public Integer getVideoFrameRateMax() {
        return videoFrameRateMax;
    }

    public void setVideoFrameRateMax(Integer videoFrameRateMax) {
        this.videoFrameRateMax = videoFrameRateMax;
    }

    @Override
    public Integer getVideoHeightMin() {
        return videoHeightMin;
    }

    public void setVideoHeightMin(Integer videoHeightMin) {
        this.videoHeightMin = videoHeightMin;
    }

    @Override
    public Integer getVideoHeightMax() {
        return videoHeightMax;
    }

    public void setVideoHeightMax(Integer videoHeightMax) {
        this.videoHeightMax = videoHeightMax;
    }

    @Override
    public Integer getVideoWidthMin() {
        return videoWidthMin;
    }

    public void setVideoWidthMin(Integer videoWidthMin) {
        this.videoWidthMin = videoWidthMin;
    }

    @Override
    public Integer getVideoWidthMax() {
        return videoWidthMax;
    }

    public void setVideoWidthMax(Integer videoWidthMax) {
        this.videoWidthMax = videoWidthMax;
    }

    @Override
    public Integer getVideoSizeMbMax() {
        return videoSizeMbMax;
    }

    public void setVideoSizeMbMax(Integer videoSizeMbMax) {
        this.videoSizeMbMax = videoSizeMbMax;
    }

    @Override
    public List<String> getAllowedVideoHwRatio() {
        return allowedVideoHwRatio;
    }

    public void setAllowedVideoHwRatio(List<String> allowedVideoHwRatio) {
        this.allowedVideoHwRatio = allowedVideoHwRatio;
    }

    @Override
    public List<String> getAllowedVideoCodecs() {
        return allowedVideoCodecs;
    }

    public void setAllowedVideoCodecs(List<String> allowedVideoCodecs) {
        this.allowedVideoCodecs = allowedVideoCodecs;
    }

    @Override
    public Boolean getAudioRequired() {
        return audioRequired;
    }

    public void setAudioRequired(Boolean audioRequired) {
        this.audioRequired = audioRequired;
    }

    @Override
    public Double getAudioDurationMin() {
        return audioDurationMin;
    }

    public void setAudioDurationMin(Double audioDurationMin) {
        this.audioDurationMin = audioDurationMin;
    }

    @Override
    public Double getAudioDurationMax() {
        return audioDurationMax;
    }

    public void setAudioDurationMax(Double audioDurationMax) {
        this.audioDurationMax = audioDurationMax;
    }

    @Override
    public List<String> getAllowedAudioCodecs() {
        return allowedAudioCodecs;
    }

    public void setAllowedAudioCodecs(List<String> allowedAudioCodecs) {
        this.allowedAudioCodecs = allowedAudioCodecs;
    }

    @Override
    public Map<String, Object> getDurationLimitsByRatio() {
        return durationLimitsByRatio;
    }

    public void setDurationLimitsByRatio(
            Map<String, Object> durationLimitsByRatio) {
        this.durationLimitsByRatio = durationLimitsByRatio;
    }

    @Override
    public List<String> getKnownMimeTypes() {
        return knownMimeTypes;
    }

    public void setKnownMimeTypes(List<String> knownMimeTypes) {
        this.knownMimeTypes = knownMimeTypes;
    }


    @Override
    public String getVideoFileHelpUrl() {
        return videoFileHelpUrl;
    }

    public void setVideoFileHelpUrl(String videoFileHelpUrl) {
        this.videoFileHelpUrl = videoFileHelpUrl;
    }
}
