package ru.yandex.canvas.service;

import java.util.List;
import java.util.Map;

public interface VideoLimitsInterface {
    Double getDurationMin();

    Double getDurationMax();

    Double getDurationCaptureStop();

    Double getDurationDelta();

    Integer getVideoFrameRateMin();

    Integer getVideoFrameRateMax();

    Integer getVideoHeightMin();

    Integer getVideoHeightMax();

    Integer getVideoWidthMin();

    Integer getVideoWidthMax();

    Integer getVideoSizeMbMax();

    List<String> getAllowedVideoHwRatio();

    List<String> getAllowedVideoCodecs();

    Boolean getAudioRequired();

    Double getAudioDurationMin();

    Double getAudioDurationMax();

    List<String> getAllowedAudioCodecs();

    Map<String, Object> getDurationLimitsByRatio();

    List<String> getKnownMimeTypes();

    String getVideoFileHelpUrl();
}
