package ru.yandex.canvas.service.direct;

import ru.yandex.canvas.model.CreativeDocument;
import ru.yandex.canvas.model.direct.CreativeUploadData;
import ru.yandex.canvas.model.direct.DirectUploadableHelperService;

import static ru.yandex.canvas.service.PresetsService.GEO_PIN_PRESET_IDS;
import static ru.yandex.canvas.service.PresetsService.IN_BANNER_PRESET_IDS;

public class CreativeUploadHelperFacade implements DirectUploadableHelperService<CreativeDocument> {
    private final CreativeDirectUploadHelper creativeDirectUploadHelper;
    private final GeoPinDirectUploadHelper geoPinDirectUploadHelper;
    private final InBannerDirectUploadHelper inBannerDirectUploadHelper;

    public CreativeUploadHelperFacade(CreativeDirectUploadHelper creativeDirectUploadHelper,
                                      GeoPinDirectUploadHelper geoPinDirectUploadHelper,
                                      InBannerDirectUploadHelper inBannerDirectUploadHelper) {
        this.creativeDirectUploadHelper = creativeDirectUploadHelper;
        this.geoPinDirectUploadHelper = geoPinDirectUploadHelper;
        this.inBannerDirectUploadHelper = inBannerDirectUploadHelper;
    }

    @Override
    public CreativeUploadData toCreativeUploadData(CreativeDocument creativeDocument, long clientId) {
        if (creativeDocument.getPresetId() != null && IN_BANNER_PRESET_IDS.contains(creativeDocument.getPresetId())) {
            return inBannerDirectUploadHelper.toCreativeUploadData(creativeDocument, clientId);
        } else if (creativeDocument.getPresetId() == null || !GEO_PIN_PRESET_IDS.contains(creativeDocument.getPresetId())) {
            return creativeDirectUploadHelper.toCreativeUploadData(creativeDocument, clientId);
        } else {
            return geoPinDirectUploadHelper.toCreativeUploadData(creativeDocument, clientId);
        }

    }
}
