package ru.yandex.canvas.service.direct;

import java.util.Map;
import java.util.Set;

import org.apache.commons.lang3.StringUtils;

import ru.yandex.canvas.model.CreativeDocument;
import ru.yandex.canvas.model.elements.Element;
import ru.yandex.canvas.service.PreviewUrlBuilder;

import static java.util.Collections.emptyMap;
import static java.util.stream.Collectors.toMap;
import static ru.yandex.canvas.service.PresetsService.GEO_PIN_PRESET_IDS;

public class GeoPinDirectUploadHelper extends AbstractDirectUploadHelper {
    private static final Set<Integer> PRESET_IDS_WITH_TYPED_IMAGES = GEO_PIN_PRESET_IDS;

    public GeoPinDirectUploadHelper(PreviewUrlBuilder previewUrlBuilder) {
        super(previewUrlBuilder);
    }

    @Override
    protected Map<String, String> getMediaSetTypes(CreativeDocument creative) {
        return PRESET_IDS_WITH_TYPED_IMAGES.contains(creative.getPresetId())
                ? creative.getData().onlyVisibleData().getElements().stream() // elements resolve type by MediaSet
                .filter(element -> StringUtils.isNoneBlank(element.getMediaSet()))
                .collect(toMap(
                        Element::getMediaSet,
                        Element::getType
                ))
                : emptyMap();
    }


}
