package ru.yandex.canvas.service.direct;

import ru.yandex.canvas.model.CreativeDocument;
import ru.yandex.canvas.model.direct.CreativeUploadData;
import ru.yandex.canvas.model.video.files.InBannerVideo;
import ru.yandex.canvas.repository.video.VideoFilesRepository;
import ru.yandex.canvas.service.PreviewUrlBuilder;
import ru.yandex.canvas.service.video.InBannerVideoFilesService;

public class InBannerDirectUploadHelper extends AbstractDirectUploadHelper {

    private final InBannerVideoFilesService inBannerVideoFilesService;

    public InBannerDirectUploadHelper(PreviewUrlBuilder previewUrlBuilder,
                                      InBannerVideoFilesService inBannerVideoFilesService) {
        super(previewUrlBuilder);
        this.inBannerVideoFilesService = inBannerVideoFilesService;
    }

    @Override
    public CreativeUploadData toCreativeUploadData(CreativeDocument creative, long clientId) {
        CreativeUploadData creativeUploadData = super.toCreativeUploadData(creative, clientId);

        InBannerVideo videoFile = inBannerVideoFilesService.lookupMovie(creative,
                new VideoFilesRepository.QueryBuilder());

        if (videoFile != null) {
            creativeUploadData.setDuration(videoFile.getDuration());
        }

        return creativeUploadData;
    }
}
