package ru.yandex.canvas.service.html5;

import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import static ru.yandex.canvas.Html5Constants.CSS_CONTENT_TYPE;

/**
 * Помогает закостылить content-type для css файлов, которые хранятся в MDS.
 * Починить автоопределялку возможности нет, приходится писать костыль с параметром content_type
 */
public class CssMdsPatchUtils {
    private Document doc;

    public CssMdsPatchUtils(Document doc) {
        this.doc = doc;
    }

    public Document patchCss() {
        Elements cssElements = doc.select("link[rel=\"stylesheet\"]");
        for (Element e : cssElements) {
            e.attr("href", e.attr("href") + "?content_type=" + CSS_CONTENT_TYPE);
        }
        return doc;
    }
}
