package ru.yandex.canvas.service.html5;

import java.util.List;

import ru.yandex.canvas.model.html5.Creative;
import ru.yandex.canvas.repository.html5.BatchesRepository;
import ru.yandex.canvas.service.DirectService;
import ru.yandex.canvas.service.OnCreativeService;
import ru.yandex.canvas.service.RTBHostExportService;
import ru.yandex.canvas.service.direct.Html5CreativeDirectUploadHelper;
import ru.yandex.canvas.service.rtbhost.helpers.creative.Html5DspUploadHelper;

/*
    Реализация OnCreativeService для html5-креативов, поставляющая креативы готовые для отправки в rtbhost
    Необходимость этого класса обсуловлена тем, что дозаполнение креатива для отправки в rtbhost - дорогая операция.
    Поэтому такой хак.
 */
public class Html5CreativesForRtbHostService extends Html5CreativesService implements OnCreativeService<Creative> {
    public Html5CreativesForRtbHostService(BatchesRepository batchesRepository,
                                           Html5SourcesService sourcesService,
                                           DirectService directService,
                                           RTBHostExportService rtbHostExportService,
                                           Html5DspUploadHelper html5DspUploadHelper,
                                           Html5CreativeDirectUploadHelper html5CreativeDirectUploadHelper) {
        super(batchesRepository, sourcesService, directService, rtbHostExportService, html5DspUploadHelper,
                html5CreativeDirectUploadHelper);
    }

    @Override
    public List<Creative> fetchByIds(List<Long> creativeIds) {
        List<Creative> creatives = super.fetchByIds(creativeIds);
        enrichCreativesWithSources(creatives);

        return creatives;
    }
}
