package ru.yandex.canvas.service.html5;

import java.io.StringWriter;
import java.util.Map;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;

import ru.yandex.canvas.model.html5.Source;

/**
 * фотоателье для баннеров со сложной механикой
 */
public class Html5PhotoStudio {
    public static final int EXPANDED_HEIGHT = 503;
    public static final int EXPANDED_WIDTH = 728;
    private final Source source;
    private final String urlMainBanner;//основной баннер для расхлопа. Нужен отдельный скриншот

    public Html5PhotoStudio(Source source, String urlMainBanner) {
        this.source = source;
        this.urlMainBanner = urlMainBanner;
    }

    public long getHeight() {
        return EXPANDED_HEIGHT;
    }

    public long getWidth() {
        return EXPANDED_WIDTH;
    }

    public String asHtml() {
        Mustache mustache = new DefaultMustacheFactory().compile("html5_expanded_photostudio_template.html");
        StringWriter writer = new StringWriter();
        mustache.execute(writer, Map.of("index_screensoot_url",urlMainBanner,
                "expanded_url", source.getExpandedHtmlUrl()));
        writer.flush();
        return writer.toString();
    }
}
