package ru.yandex.canvas.service.html5;

import java.util.Objects;

import ru.yandex.canvas.model.Size;

public class Html5Preset {
    private final Integer id;
    private final Size size;

    public Html5Preset(Integer id, Size size) {
        this.id = id;
        this.size = size;
    }

    public Integer getId() {
        return id;
    }

    public Size getSize() {
        return size;
    }

    public String getName() {
        return size.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        Html5Preset that = (Html5Preset) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(size, that.size);
    }

    @Override
    public int hashCode() {
        return Objects.hash(id, size);
    }

    @Override
    public String toString() {
        return "Html5Preset{" +
                "id=" + id +
                ", size=" + size +
                '}';
    }
}
