package ru.yandex.canvas.service.html5;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

import org.asynchttpclient.Request;
import org.asynchttpclient.RequestBuilder;

import ru.yandex.canvas.model.html5.Source;
import ru.yandex.direct.asynchttp.ParallelFetcher;
import ru.yandex.direct.asynchttp.ParallelFetcherFactory;
import ru.yandex.direct.asynchttp.ParsableBytesRequest;
import ru.yandex.direct.asynchttp.ParsableRequest;
import ru.yandex.direct.asynchttp.Result;

import static org.asynchttpclient.util.HttpConstants.Methods.GET;

public class ZipDownloader {

    private ParallelFetcherFactory parallelFetcherFactory;
    private List<Source> sources;

    public ZipDownloader(ParallelFetcherFactory parallelFetcherFactory, List<Source> sources) {
        this.parallelFetcherFactory = parallelFetcherFactory;
        this.sources = sources;
    }

    public void download() throws InterruptedException, IOException {
        Map<Long, Result<ParsableBytesRequest.Byteswrapper>> resultMap;

        try (ParallelFetcher<ParsableBytesRequest.Byteswrapper> fetcher = parallelFetcherFactory.getParallelFetcher()) {
            List<ParsableRequest<ParsableBytesRequest.Byteswrapper>> asyncRequests =
                    IntStream.range(0, sources.size())
                            .mapToObj(r -> {
                                RequestBuilder builder = new RequestBuilder(GET)
                                        .setUrl(sources.get(r).getUrl());
                                //TODO   .setRequestTimeout(Ints.checkedCast(timeout.toMillis()))
                                Request innerRequest = builder.build();
                                return new ParsableBytesRequest(r, innerRequest);
                            }).collect(Collectors.toList());

            resultMap = fetcher.execute(asyncRequests);
        }

        for (Long id : resultMap.keySet()) {
            Result<ParsableBytesRequest.Byteswrapper> res = resultMap.get(id);

            if (res.getErrors() != null && !res.getErrors().isEmpty()) {
                throw new IOException("Zip download failed, errors: " + res.getErrors());
            }

            sources.get(id.intValue()).setArchiveContent(res.getSuccess().getContent());
        }
    }
}
