package ru.yandex.canvas.service.idea.modifiers;

import java.util.function.BiConsumer;

import org.jetbrains.annotations.NotNull;

import ru.yandex.canvas.model.CreativeData;
import ru.yandex.canvas.model.DraftCreative;

public class CreativeColorModifier implements CreativeModifier {
    private final String newColor;
    private final ColorKind colorKind;

    public CreativeColorModifier(@NotNull ColorKind colorKind, @NotNull String newColor) {
        this.newColor = newColor;
        this.colorKind = colorKind;
    }

    @Override
    public void modify(@NotNull DraftCreative draftCreative) {
        colorKind.colorSetter.accept(draftCreative.getData().getOptions(), newColor);
    }


    public enum ColorKind {
        Background(CreativeData.Options::setBackgroundColor),
        Border(CreativeData.Options::setBorderColor);

        private final BiConsumer<CreativeData.Options, String> colorSetter;

        ColorKind(BiConsumer<CreativeData.Options, String> colorSetter) {
            this.colorSetter = colorSetter;
        }
    }
}
