package ru.yandex.canvas.service.idea.modifiers;

import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.canvas.model.DraftCreative;
import ru.yandex.canvas.model.elements.Element;

public class ElementBackgroundColorModifier implements CreativeModifier {
    private final Set<String> types;

    private final String newColor;

    public ElementBackgroundColorModifier(@NotNull Set<String> types, @NotNull String newColor) {
        this.types = types;
        this.newColor = newColor;
    }

    @Override
    public void modify(@NotNull DraftCreative draftCreative) {
        draftCreative.getData().getElements()
                .stream()
                .filter(element -> types.contains(element.getType()))
                .filter(element -> element.getOptions() instanceof Element.ColoredTextOptionsWithBackground)
                .forEach(element -> ((Element.ColoredTextOptionsWithBackground) element.getOptions())
                        .setBackgroundColor(newColor));
    }
}
