package ru.yandex.canvas.service.idea.modifiers;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

import org.jetbrains.annotations.NotNull;

import ru.yandex.canvas.model.DraftCreative;
import ru.yandex.canvas.model.elements.Element;
import ru.yandex.canvas.model.elements.Fade;

public class ElementColorModifier implements CreativeModifier {
    private final Set<String> types;

    private final String newColor;

    public ElementColorModifier(Set<String> types, String newColor) {
        this.types = types;
        this.newColor = newColor;
    }

    @Override
    public void modify(@NotNull DraftCreative draftCreative) {
        List<Element> matchedElements = draftCreative.getData().getElements()
                .stream()
                .filter(element -> types.contains(element.getType()))
                .collect(Collectors.toList());

        matchedElements.stream()
                .filter(element -> types.contains(element.getType()))
                .filter(element -> element.getOptions() instanceof Element.ColoredTextOptions)
                .forEach(element -> ((Element.ColoredTextOptions) element.getOptions()).setColor(newColor));

        matchedElements.stream().filter(element -> element instanceof Fade)
                .forEach(element -> ((Fade) element).getOptions().setColor(newColor));
    }
}
