package ru.yandex.canvas.service.idea.modifiers;

import org.jetbrains.annotations.NotNull;

import ru.yandex.canvas.model.DraftCreative;

public class ElementDisableModifier implements CreativeModifier {
    private final String type;

    public ElementDisableModifier(@NotNull String type) {
        this.type = type;
    }

    @Override
    public void modify(@NotNull DraftCreative draftCreative) {
        draftCreative.getData().getElements().stream()
                .filter(element -> element.getType().equals(type))
                .forEach(element -> element.setAvailable(false));
    }
}
