package ru.yandex.canvas.service.idea.modifiers;

import java.util.Set;

import org.jetbrains.annotations.NotNull;

import ru.yandex.canvas.model.DraftCreative;
import ru.yandex.canvas.model.elements.Element;

public class ElementTextModifier implements CreativeModifier {
    private final Set<String> types;

    private final String newContent;

    public ElementTextModifier(@NotNull Set<String> types, @NotNull String newContent) {
        this.types = types;
        this.newContent = newContent;
    }

    @Override
    public void modify(@NotNull DraftCreative draftCreative) {
        draftCreative.getData().getElements()
                .stream()
                .filter(element -> types.contains(element.getType()))
                .filter(element -> element.getOptions() instanceof Element.ColoredTextOptions)
                .forEach(element -> ((Element.ColoredTextOptions) element.getOptions()).setContent(newContent));
    }
}
