package ru.yandex.canvas.service.idea.modifiers;

import java.util.Set;
import java.util.stream.Collectors;

import org.jetbrains.annotations.NotNull;

import ru.yandex.canvas.model.DraftCreative;
import ru.yandex.canvas.model.File;
import ru.yandex.canvas.model.elements.Element;


//modifies preset images to the given one
public class ImageModifier implements CreativeModifier {
    private static final String IMAGE_MEDIA_SET_TYPE = "image";
    private static final String WIDTH_METADATA = "width";
    private static final String HEIGHT_PROPERTY = "height";
    private final File image;
    private String elementType;

    public ImageModifier(@NotNull File image, @NotNull String elementType) {
        this.image = image;
        this.elementType = elementType;
    }

    @Override
    public void modify(@NotNull DraftCreative draftCreative) {
        Set<String> imagesMediaSets = draftCreative.getData().getElements().stream()
                .filter(element -> elementType.equals(element.getType()))
                .map(Element::getMediaSet)
                .collect(Collectors.toSet());

        draftCreative.getData().getMediaSets().entrySet().stream()
                .filter((mediaSetEntry) -> imagesMediaSets.contains(mediaSetEntry.getKey()))
                .forEach(
                        mediaSetEntry ->
                                mediaSetEntry.getValue().getItems().stream()
                                        .filter(mediaSetItem -> IMAGE_MEDIA_SET_TYPE.equals(mediaSetItem.getType()))
                                        .forEach(
                                                mediaSetItem -> {
                                                    mediaSetItem.getItems()
                                                            .forEach(
                                                                    imageSubItem -> {
                                                                        imageSubItem.setUrl(image.getUrl());
                                                                        imageSubItem.setHeight(
                                                                                (Integer) image.getStillageFileInfo()
                                                                                        .getMetadataInfo()
                                                                                        .get(HEIGHT_PROPERTY));
                                                                        imageSubItem.setWidth(
                                                                                (Integer) image.getStillageFileInfo()
                                                                                        .getMetadataInfo()
                                                                                        .get(WIDTH_METADATA));
                                                                        imageSubItem.setFileId(image.getId());
                                                                    });
                                                })
                );


    }
}
