package ru.yandex.canvas.service.idea.modifiers;

import java.util.Set;
import java.util.stream.Collectors;

import org.jetbrains.annotations.NotNull;

import ru.yandex.canvas.model.DraftCreative;
import ru.yandex.canvas.model.elements.Element;
import ru.yandex.canvas.model.stillage.StillageFileInfo;


//modifies preset media sets images to the given one
public class RawImageModifier implements CreativeModifier {
    private static final String IMAGE_MEDIA_SET_TYPE = "image";
    private static final String WIDTH_METADATA = "width";
    private static final String HEIGHT_PROPERTY = "height";
    private final StillageFileInfo stillageImage;
    private String elementType;

    public RawImageModifier(@NotNull StillageFileInfo stillageImage, @NotNull String elementType) {
        this.stillageImage = stillageImage;
        this.elementType = elementType;
    }

    @Override
    public void modify(@NotNull DraftCreative draftCreative) {
        Set<String> imagesMediaSets = draftCreative.getData().getElements().stream()
                .filter(element -> elementType.equals(element.getType()))
                .map(Element::getMediaSet)
                .collect(Collectors.toSet());

        draftCreative.getData().getMediaSets().entrySet().stream()
                .filter((mediaSetEntry) -> imagesMediaSets.contains(mediaSetEntry.getKey()))
                .forEach(
                        mediaSetEntry ->
                                mediaSetEntry.getValue().getItems().stream()
                                        .filter(mediaSetItem -> IMAGE_MEDIA_SET_TYPE.equals(mediaSetItem.getType()))
                                        .forEach(
                                                mediaSetItem -> {
                                                    mediaSetItem.getItems()
                                                            .forEach(
                                                                    imageSubItem -> {
                                                                        imageSubItem.setUrl(stillageImage.getUrl());
                                                                        imageSubItem.setHeight((Integer) stillageImage
                                                                                .getMetadataInfo()
                                                                                .get(HEIGHT_PROPERTY));
                                                                        imageSubItem.setWidth((Integer) stillageImage
                                                                                .getMetadataInfo().get(WIDTH_METADATA));
                                                                    });
                                                })
                );


    }
}
