package ru.yandex.canvas.service.multitype;

import ru.yandex.canvas.model.CreativeDocument;
import ru.yandex.canvas.model.CreativeWithId;
import ru.yandex.canvas.model.html5.Creative;
import ru.yandex.canvas.model.video.Addition;
import ru.yandex.canvas.model.video.StockAddition;

public enum CreativeType {
    // по одному классу на каждый тип, т.к. маппинг должен работать в обе стороны
    HTML5(Creative.class),
    AD_BUILDER(CreativeDocument.class), // ГО по креативам
    VIDEO(Addition.class),
    STOCK_VIDEO(StockAddition.class); // особый случай :)

    private Class<? extends CreativeWithId> creativeClass;

    CreativeType(Class<? extends CreativeWithId> creativeClass) {
        this.creativeClass = creativeClass;
    }

    public Class<? extends CreativeWithId> getCreativeClass() {
        return creativeClass;
    }

    public static CreativeType fromCreativeClass(Class<? extends CreativeWithId> creativeClass) {
        for (CreativeType type : CreativeType.values()) {
            if (type.getCreativeClass().equals(creativeClass)) {
                return type;
            }
        }

        throw new IllegalArgumentException("Class " + creativeClass.getName() + " not registered in CreativeType enum");
    }
}
