package ru.yandex.canvas.service.multitype;

import java.util.Map;

import ru.yandex.canvas.service.OnCreativeService;
import ru.yandex.canvas.service.multitype.request.MultiCreativeTypeOperationRequest;

public interface MultiCreativeTypeOperation<T extends MultiCreativeTypeOperationRequest> {
    void init(Map<CreativeType, SingleCreativeTypeOperation> operationsByType,
            Map<CreativeType, OnCreativeService<?>> filterByType);

    Map<Long, OnCreativeOperationResult> run(T request);

    OnCreativeServiceProvider getOnCreativeServiceProvider();

    default OnCreativeService provideService(CreativeType type) {
        return getOnCreativeServiceProvider().provide(type);
    }
}
