package ru.yandex.canvas.service.multitype;

import java.util.Collections;
import java.util.List;

import javax.annotation.Nullable;

import com.fasterxml.jackson.annotation.JsonProperty;

/**
 * Результаты операции над списком креативов
 * Велосипед, единообразия для правильнее было бы использовать Errors, но тут это кажется overkill
 * плюс с десериализованным errors будет сложнее работать на стороне клиента, в то время как
 * возможности Errors не нужны
 */
public class OnCreativeOperationResult {
    private static final String NOT_FOUND_OR_NOT_SUPPORTED_MESSAGE
            = "Creative not found, or it's type not supported by operation";
    @JsonProperty("status")
    private ResultStatus status;

    @JsonProperty("errors")
    private List<String> errors;

    private OnCreativeOperationResult(ResultStatus status,
            @Nullable List<String> errors) {
        this.status = status;
        this.errors = errors;
    }

    public static OnCreativeOperationResult notFoundOrNotSupported() {
        return error(NOT_FOUND_OR_NOT_SUPPORTED_MESSAGE);
    }
    public static OnCreativeOperationResult ok() {
        return new OnCreativeOperationResult(ResultStatus.OK, null);
    }

    public static OnCreativeOperationResult error(String error) {
        return errors(Collections.singletonList(error));
    }

    public static OnCreativeOperationResult errors(List<String> errors) {
        return new OnCreativeOperationResult(ResultStatus.ERROR, errors);
    }

    public enum ResultStatus {
        OK,
        ERROR
    }

    @Override
    public String toString() {
        return "OnCreativeOperationResult{" +
                "status=" + status +
                ", errors=" + errors +
                '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        OnCreativeOperationResult that = (OnCreativeOperationResult) o;

        if (status != that.status) {
            return false;
        }
        return errors != null ? errors.equals(that.errors) : that.errors == null;
    }

    @Override
    public int hashCode() {
        int result = status.hashCode();
        result = 31 * result + (errors != null ? errors.hashCode() : 0);
        return result;
    }
}
