package ru.yandex.canvas.service.multitype;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

import ru.yandex.canvas.service.OnCreativeService;

public class OnCreativeServiceProvider {
    private final Map<CreativeType, OnCreativeService> serviceByType;
    public OnCreativeServiceProvider(OnCreativeService...services) {
        serviceByType = Arrays.asList(services).stream().collect(Collectors.toMap(
                s -> CreativeType.fromCreativeClass(s.worksOn()),
                Function.identity()
        ));
    }

    public OnCreativeService provide(CreativeType type) {
        if (!serviceByType.containsKey(type)) {
            throw new IllegalStateException("CreativeType: " + type + " not registered in provider");
        }
        return serviceByType.get(type);
    }
}
